"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const ByteArray_1 = require("../internal/ByteArray");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const CallLinkAuthCredentialPresentation_1 = require("./CallLinkAuthCredentialPresentation");
class CallLinkAuthCredential extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CallLinkAuthCredential_CheckValidContents);
    }
    present(userId, redemptionTime, serverParams, callLinkParams) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.presentWithRandom(userId, redemptionTime, serverParams, callLinkParams, random);
    }
    presentWithRandom(userId, redemptionTime, serverParams, callLinkParams, random) {
        return new CallLinkAuthCredentialPresentation_1.default(Native.CallLinkAuthCredential_PresentDeterministic(this.contents, userId.getServiceIdFixedWidthBinary(), redemptionTime, serverParams.contents, callLinkParams.contents, random));
    }
}
exports.default = CallLinkAuthCredential;
//# sourceMappingURL=CallLinkAuthCredential.js.map